<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Address extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;
    protected $fillable = array('name', 'city_id', 'latitude', 'longitude', 'user_id');

    public function city()
    {
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

}